// ==UserScript==
// @name         V3 - Get Old YouTube Layout [ TurboLauncher ]
// @namespace    //www.github.com/VORAPIS
// @version      2.0.0.0
// @author       eov3cv@hotmail.com
// @match        https://www.youtube.com/*
// @match        https://www.googleapis.com/youtube/
// @match        https://youtube.clients6.google.com/
// @match        https://content-youtube.googleapis.com/
// @match		 https://myactivity.google.com/
// @match		 https://storage.googleapis.com/discovery/
// @icon         https://www.google.com/s2/favicons?sz=64&domain=youtube.com
// @grant        none
// @run-at       document-start
// ==/UserScript==

//Project VORAPIS (V3) License & Disclaimer
//LZString is not part of V3, license mentioned below.
//
//Copyright (c) 2025 VORAPIS (eov3cv@hotmail.com)
//
//All rights reserved.
//
//DISCLAIMER
//
//Project VORAPIS (short. V3) is a JavaScript application developed to run as a userscript/extension on www.youtube.com, aiming to recreate the experience of using YouTube as it was in 2013-2014.
//It is important to note:
//
//1. This project is not funded, endorsed, or affiliated with Google LLC, YouTube, or any of their subsidiaries. V3 is developed independently and operates within the Terms of Service (TOS) of the utilized Google and YouTube services, including but not limited to "My Activity", "InnerTube", and "YouTube Data API v3".
//
//2. The developer(s) of V3 claim rights only to the original code that powers this library. No claim is made to any CSS, HTML, JavaScript, or other assets owned by Google, YouTube, or their subsidiaries. This includes a modified version of the 2014 Google/YouTube HTML5 player, adapted for compatibility with today's APIs. The modification efforts are acknowledged, but proprietary rights to the original player remain with Google/YouTube.
//
//LICENSE TERMS
//
//The V3 project is provided "as is" for personal, non-commercial use, free of charge, with the following conditions:
//
//- Sale or any form of commercial exploitation of V3 is strictly prohibited.
//- Users are not allowed to claim V3 or any of its parts as their own work.
//- The developer(s) of V3 offer no warranties or guarantees regarding the software's functionality, performance, or its compliance with any legal standards.
//
//LIMITATION OF LIABILITY
//
//Under no circumstances shall the developer(s) of V3 be liable for any direct, indirect, incidental, special, or consequential damages resulting from the use of or inability to use the project, including but not limited to reliance on any information obtained through the project; or any failure of performance.
//
//COPYRIGHT NOTICE
//
//Copyright (c) 2025 Project VORAPIS. All rights reserved.
//
//By downloading, accessing, or using V3, you acknowledge that you have read, understood, and agree to comply with the terms and conditions outlined in this license and disclaimer.

//page script

(function(){

window["PatcherJSC_TURBOPIPE"] = window["PatcherJSC_TURBOPIPE"] || {
	other_msg: function(msg){
		if (!msg || !msg.mission) return console.error("error: there is no mission");
		switch (msg.mission) {
			case 0:
				if (!msg.map) return console.error("error: there is no map config");
				for (var k in msg.map) {
					turbo_launcher.cfg.data[k] = msg.map[k];
				}
				turbo_launcher.cfg.update();
			break;
		}
	}
};
var TURBO_LAUNCHER_MSG = window["PatcherJSC_TURBOPIPE"];

document.addEventListener("VLTURBO_IPC", function(e){
	if (e.detail) e = e.detail;
	if (e.msg) TURBO_LAUNCHER_MSG.other_msg(e.msg);
});

window["trusted_policy"] = window["trustedTypes"] ? (window["trustedTypes"].createPolicy("VOR_TRUSTED_USELESS_POLICY", {
	createHTML: function(a){
		return a;
	}
})) : {
	createHTML: function(a){
		return a;
	}
};

/*begin fix browser policy thank you http://... */

if (window.trustedTypes && window.trustedTypes.createPolicy && !window.trustedTypes.defaultPolicy) {
	window.trustedTypes.createPolicy('default', {
		createHTML: function(string){
			return string;
		},
		createScriptURL: function(string){
			return string;
		},
		createScript: function(string){
			return string;
		},
	});
};

/*end fix browser policy end*/

window["PatcherJSC_TURBO_RUNNING"] = true;
var turbo_launcher = {};
turbo_launcher.cfg = {};
turbo_launcher.cfg.init = function(){
	if (!window.localStorage) return console.error("There is no LocalStorage API!");
	turbo_launcher.cfg.data = JSON.parse(window.localStorage.getItem("VLTURBO_CFG") || "{\"VLTURBO_EMBED_PAGE\":true}");
	turbo_launcher.cfg.update();
};
turbo_launcher.cfg.update = function(){
	if (!window.localStorage) return console.error("There is no LocalStorage API!");
	window.localStorage.setItem("VLTURBO_CFG", JSON.stringify(turbo_launcher.cfg.data || {}));
};
turbo_launcher.gcc = {};
turbo_launcher.gcc.url = "https://vorapis.pages.dev/product/v3/game_service/patcher/get_latest_client";
turbo_launcher.xhr = function(addr, callback, ir){
	var xhr = new XMLHttpRequest();
	xhr.onreadystatechange = function() {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				callback(null, xhr.responseText);
			} else {
				callback(new Error(xhr.status));
			}
		}
	};
	xhr.open('GET', (addr + (!ir ? ("?t=" + (new Date()).getTime()) : "")), true);
	xhr.send();
};
turbo_launcher.lsextra = {};
turbo_launcher.lsextra.get_size = function(){
	var sz = 0;
	if (!s) {
		var i = 0;
		try {
			for (i = 250; i <= 10000; i += 250) {
				localStorage.setItem('TEST_LIMIT', new Array((i * 1024) + 1).join('a'));
			}
		} catch (e) {
			localStorage.removeItem('TEST_LIMIT');
			sz = ((i - 250)*1024 + 1);         
		}
	}
	return sz;
};
turbo_launcher.lsextra.assure = function(){
	return console.error("error: not implemented yet.");
};
turbo_launcher.vss = {};
turbo_launcher.vss.get = function(){
	if (!window.location.pathname.indexOf("/embed/") && !turbo_launcher.cfg.data.EMBED_PAGE) {
		return console.log("EMBED_PAGE is disable.");
	}
	var ls = window.localStorage;
	if (!ls) {
		return console.error("LocalStorage error!");
	}
	var info = ls.getItem("VLTURBO_INFO");
	var data = ls.getItem("VLTURBO_DATA");
	var state = ls.getItem("VLTURBO_STATE");
	var imp = false;
	if (data) {
		imp = true;
		var s = document.createElement("script");
		var data_script = (state == 'a' ? data : LZString144.decompress(data));
		s.innerHTML = window["trusted_policy"].createHTML(data_script);
		document.documentElement.appendChild(s);
	} else {
		window.stop();
	}
	function onGetVer(err, cvss){
		if (err) {
			return console.error("Xhr error!", err);
		}
		try{
			ls.setItem("VLTURBO_DATA", cvss);
			ls.setItem("VLTURBO_STATE", 'a');
		}catch(e){
			try{
				ls.setItem("VLTURBO_DATA", LZString144.compress(cvss));
				ls.setItem("VLTURBO_STATE", 'b');
			}catch(e){
				if (e.name == "QuotaExceededError") {
					console.error("[V3 TURBOLAUNCHER] Your browser does not support auto-updating. Please visit: https://vorapis.pages.dev/");
				}
				return console.error("LocalStorage Api Error", e);
			}
		}
		if (!imp) {
			window.location.reload();
		} else {
			TURBO_LAUNCHER_MSG.updated = true;
			if (TURBO_LAUNCHER_MSG.update_msg) TURBO_LAUNCHER_MSG.update_msg();
			else document.dispatchEvent(new CustomEvent("VLTURBO_IPC", {
				detail: {
					type: "update_msg"
				}
			}));
		}
	};
	function onCallback(err, cver){
		if (err) {
			return console.error("Xhr error!", err);
		}
		if (info != cver) {
			turbo_launcher.xhr(cver, onGetVer, true);
		}
		ls.setItem("VLTURBO_INFO", cver);
	};
	return turbo_launcher.xhr(turbo_launcher.gcc.url, onCallback);
};
turbo_launcher.main = function(){
	turbo_launcher.cfg.init();
	turbo_launcher.vss.get();
};

//here start LZString code
// Copyright (c) 2013 Pieroxy <pieroxy@pieroxy.net>
// This work is free. You can redistribute it and/or modify it
// under the terms of the WTFPL, Version 2
// For more information see LICENSE.txt or http://www.wtfpl.net/
//
// For more information, the home page:
// http://pieroxy.net/blog/pages/lz-string/testing.html
//
// LZ-based compression algorithm, version 1.4.4
var LZString144 = (function() {

// private property
var f = String.fromCharCode;
var keyStrBase64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
var keyStrUriSafe = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$";
var baseReverseDic = {};

function getBaseValue(alphabet, character) {
  if (!baseReverseDic[alphabet]) {
    baseReverseDic[alphabet] = {};
    for (var i=0 ; i<alphabet.length ; i++) {
      baseReverseDic[alphabet][alphabet.charAt(i)] = i;
    }
  }
  return baseReverseDic[alphabet][character];
}

var LZString144 = {
  compressToBase64 : function (input) {
    if (input == null) return "";
    var res = LZString144._compress(input, 6, function(a){return keyStrBase64.charAt(a);});
    switch (res.length % 4) { // To produce valid Base64
    default: // When could this happen ?
    case 0 : return res;
    case 1 : return res+"===";
    case 2 : return res+"==";
    case 3 : return res+"=";
    }
  },

  decompressFromBase64 : function (input) {
    if (input == null) return "";
    if (input == "") return null;
    return LZString144._decompress(input.length, 32, function(index) { return getBaseValue(keyStrBase64, input.charAt(index)); });
  },

  compressToUTF16 : function (input) {
    if (input == null) return "";
    return LZString144._compress(input, 15, function(a){return f(a+32);}) + " ";
  },

  decompressFromUTF16: function (compressed) {
    if (compressed == null) return "";
    if (compressed == "") return null;
    return LZString144._decompress(compressed.length, 16384, function(index) { return compressed.charCodeAt(index) - 32; });
  },

  //compress into uint8array (UCS-2 big endian format)
  compressToUint8Array: function (uncompressed) {
    var compressed = LZString144.compress(uncompressed);
    var buf=new Uint8Array(compressed.length*2); // 2 bytes per character

    for (var i=0, TotalLen=compressed.length; i<TotalLen; i++) {
      var current_value = compressed.charCodeAt(i);
      buf[i*2] = current_value >>> 8;
      buf[i*2+1] = current_value % 256;
    }
    return buf;
  },

  //decompress from uint8array (UCS-2 big endian format)
  decompressFromUint8Array:function (compressed) {
    if (compressed===null || compressed===undefined){
        return LZString144.decompress(compressed);
    } else {
        var buf=new Array(compressed.length/2); // 2 bytes per character
        for (var i=0, TotalLen=buf.length; i<TotalLen; i++) {
          buf[i]=compressed[i*2]*256+compressed[i*2+1];
        }

        var result = [];
        buf.forEach(function (c) {
          result.push(f(c));
        });
        return LZString144.decompress(result.join(''));

    }

  },


  //compress into a string that is already URI encoded
  compressToEncodedURIComponent: function (input) {
    if (input == null) return "";
    return LZString144._compress(input, 6, function(a){return keyStrUriSafe.charAt(a);});
  },

  //decompress from an output of compressToEncodedURIComponent
  decompressFromEncodedURIComponent:function (input) {
    if (input == null) return "";
    if (input == "") return null;
    input = input.replace(/ /g, "+");
    return LZString144._decompress(input.length, 32, function(index) { return getBaseValue(keyStrUriSafe, input.charAt(index)); });
  },

  compress: function (uncompressed) {
    return LZString144._compress(uncompressed, 16, function(a){return f(a);});
  },
  _compress: function (uncompressed, bitsPerChar, getCharFromInt) {
    if (uncompressed == null) return "";
    var i, value,
        context_dictionary= {},
        context_dictionaryToCreate= {},
        context_c="",
        context_wc="",
        context_w="",
        context_enlargeIn= 2, // Compensate for the first entry which should not count
        context_dictSize= 3,
        context_numBits= 2,
        context_data=[],
        context_data_val=0,
        context_data_position=0,
        ii;

    for (ii = 0; ii < uncompressed.length; ii += 1) {
      context_c = uncompressed.charAt(ii);
      if (!Object.prototype.hasOwnProperty.call(context_dictionary,context_c)) {
        context_dictionary[context_c] = context_dictSize++;
        context_dictionaryToCreate[context_c] = true;
      }

      context_wc = context_w + context_c;
      if (Object.prototype.hasOwnProperty.call(context_dictionary,context_wc)) {
        context_w = context_wc;
      } else {
        if (Object.prototype.hasOwnProperty.call(context_dictionaryToCreate,context_w)) {
          if (context_w.charCodeAt(0)<256) {
            for (i=0 ; i<context_numBits ; i++) {
              context_data_val = (context_data_val << 1);
              if (context_data_position == bitsPerChar-1) {
                context_data_position = 0;
                context_data.push(getCharFromInt(context_data_val));
                context_data_val = 0;
              } else {
                context_data_position++;
              }
            }
            value = context_w.charCodeAt(0);
            for (i=0 ; i<8 ; i++) {
              context_data_val = (context_data_val << 1) | (value&1);
              if (context_data_position == bitsPerChar-1) {
                context_data_position = 0;
                context_data.push(getCharFromInt(context_data_val));
                context_data_val = 0;
              } else {
                context_data_position++;
              }
              value = value >> 1;
            }
          } else {
            value = 1;
            for (i=0 ; i<context_numBits ; i++) {
              context_data_val = (context_data_val << 1) | value;
              if (context_data_position ==bitsPerChar-1) {
                context_data_position = 0;
                context_data.push(getCharFromInt(context_data_val));
                context_data_val = 0;
              } else {
                context_data_position++;
              }
              value = 0;
            }
            value = context_w.charCodeAt(0);
            for (i=0 ; i<16 ; i++) {
              context_data_val = (context_data_val << 1) | (value&1);
              if (context_data_position == bitsPerChar-1) {
                context_data_position = 0;
                context_data.push(getCharFromInt(context_data_val));
                context_data_val = 0;
              } else {
                context_data_position++;
              }
              value = value >> 1;
            }
          }
          context_enlargeIn--;
          if (context_enlargeIn == 0) {
            context_enlargeIn = Math.pow(2, context_numBits);
            context_numBits++;
          }
          delete context_dictionaryToCreate[context_w];
        } else {
          value = context_dictionary[context_w];
          for (i=0 ; i<context_numBits ; i++) {
            context_data_val = (context_data_val << 1) | (value&1);
            if (context_data_position == bitsPerChar-1) {
              context_data_position = 0;
              context_data.push(getCharFromInt(context_data_val));
              context_data_val = 0;
            } else {
              context_data_position++;
            }
            value = value >> 1;
          }


        }
        context_enlargeIn--;
        if (context_enlargeIn == 0) {
          context_enlargeIn = Math.pow(2, context_numBits);
          context_numBits++;
        }
        // Add wc to the dictionary.
        context_dictionary[context_wc] = context_dictSize++;
        context_w = String(context_c);
      }
    }

    // Output the code for w.
    if (context_w !== "") {
      if (Object.prototype.hasOwnProperty.call(context_dictionaryToCreate,context_w)) {
        if (context_w.charCodeAt(0)<256) {
          for (i=0 ; i<context_numBits ; i++) {
            context_data_val = (context_data_val << 1);
            if (context_data_position == bitsPerChar-1) {
              context_data_position = 0;
              context_data.push(getCharFromInt(context_data_val));
              context_data_val = 0;
            } else {
              context_data_position++;
            }
          }
          value = context_w.charCodeAt(0);
          for (i=0 ; i<8 ; i++) {
            context_data_val = (context_data_val << 1) | (value&1);
            if (context_data_position == bitsPerChar-1) {
              context_data_position = 0;
              context_data.push(getCharFromInt(context_data_val));
              context_data_val = 0;
            } else {
              context_data_position++;
            }
            value = value >> 1;
          }
        } else {
          value = 1;
          for (i=0 ; i<context_numBits ; i++) {
            context_data_val = (context_data_val << 1) | value;
            if (context_data_position == bitsPerChar-1) {
              context_data_position = 0;
              context_data.push(getCharFromInt(context_data_val));
              context_data_val = 0;
            } else {
              context_data_position++;
            }
            value = 0;
          }
          value = context_w.charCodeAt(0);
          for (i=0 ; i<16 ; i++) {
            context_data_val = (context_data_val << 1) | (value&1);
            if (context_data_position == bitsPerChar-1) {
              context_data_position = 0;
              context_data.push(getCharFromInt(context_data_val));
              context_data_val = 0;
            } else {
              context_data_position++;
            }
            value = value >> 1;
          }
        }
        context_enlargeIn--;
        if (context_enlargeIn == 0) {
          context_enlargeIn = Math.pow(2, context_numBits);
          context_numBits++;
        }
        delete context_dictionaryToCreate[context_w];
      } else {
        value = context_dictionary[context_w];
        for (i=0 ; i<context_numBits ; i++) {
          context_data_val = (context_data_val << 1) | (value&1);
          if (context_data_position == bitsPerChar-1) {
            context_data_position = 0;
            context_data.push(getCharFromInt(context_data_val));
            context_data_val = 0;
          } else {
            context_data_position++;
          }
          value = value >> 1;
        }


      }
      context_enlargeIn--;
      if (context_enlargeIn == 0) {
        context_enlargeIn = Math.pow(2, context_numBits);
        context_numBits++;
      }
    }

    // Mark the end of the stream
    value = 2;
    for (i=0 ; i<context_numBits ; i++) {
      context_data_val = (context_data_val << 1) | (value&1);
      if (context_data_position == bitsPerChar-1) {
        context_data_position = 0;
        context_data.push(getCharFromInt(context_data_val));
        context_data_val = 0;
      } else {
        context_data_position++;
      }
      value = value >> 1;
    }

    // Flush the last char
    while (true) {
      context_data_val = (context_data_val << 1);
      if (context_data_position == bitsPerChar-1) {
        context_data.push(getCharFromInt(context_data_val));
        break;
      }
      else context_data_position++;
    }
    return context_data.join('');
  },

  decompress: function (compressed) {
    if (compressed == null) return "";
    if (compressed == "") return null;
    return LZString144._decompress(compressed.length, 32768, function(index) { return compressed.charCodeAt(index); });
  },

  _decompress: function (length, resetValue, getNextValue) {
    var dictionary = [],
        next,
        enlargeIn = 4,
        dictSize = 4,
        numBits = 3,
        entry = "",
        result = [],
        i,
        w,
        bits, resb, maxpower, power,
        c,
        data = {val:getNextValue(0), position:resetValue, index:1};

    for (i = 0; i < 3; i += 1) {
      dictionary[i] = i;
    }

    bits = 0;
    maxpower = Math.pow(2,2);
    power=1;
    while (power!=maxpower) {
      resb = data.val & data.position;
      data.position >>= 1;
      if (data.position == 0) {
        data.position = resetValue;
        data.val = getNextValue(data.index++);
      }
      bits |= (resb>0 ? 1 : 0) * power;
      power <<= 1;
    }

    switch (next = bits) {
      case 0:
          bits = 0;
          maxpower = Math.pow(2,8);
          power=1;
          while (power!=maxpower) {
            resb = data.val & data.position;
            data.position >>= 1;
            if (data.position == 0) {
              data.position = resetValue;
              data.val = getNextValue(data.index++);
            }
            bits |= (resb>0 ? 1 : 0) * power;
            power <<= 1;
          }
        c = f(bits);
        break;
      case 1:
          bits = 0;
          maxpower = Math.pow(2,16);
          power=1;
          while (power!=maxpower) {
            resb = data.val & data.position;
            data.position >>= 1;
            if (data.position == 0) {
              data.position = resetValue;
              data.val = getNextValue(data.index++);
            }
            bits |= (resb>0 ? 1 : 0) * power;
            power <<= 1;
          }
        c = f(bits);
        break;
      case 2:
        return "";
    }
    dictionary[3] = c;
    w = c;
    result.push(c);
    while (true) {
      if (data.index > length) {
        return "";
      }

      bits = 0;
      maxpower = Math.pow(2,numBits);
      power=1;
      while (power!=maxpower) {
        resb = data.val & data.position;
        data.position >>= 1;
        if (data.position == 0) {
          data.position = resetValue;
          data.val = getNextValue(data.index++);
        }
        bits |= (resb>0 ? 1 : 0) * power;
        power <<= 1;
      }

      switch (c = bits) {
        case 0:
          bits = 0;
          maxpower = Math.pow(2,8);
          power=1;
          while (power!=maxpower) {
            resb = data.val & data.position;
            data.position >>= 1;
            if (data.position == 0) {
              data.position = resetValue;
              data.val = getNextValue(data.index++);
            }
            bits |= (resb>0 ? 1 : 0) * power;
            power <<= 1;
          }

          dictionary[dictSize++] = f(bits);
          c = dictSize-1;
          enlargeIn--;
          break;
        case 1:
          bits = 0;
          maxpower = Math.pow(2,16);
          power=1;
          while (power!=maxpower) {
            resb = data.val & data.position;
            data.position >>= 1;
            if (data.position == 0) {
              data.position = resetValue;
              data.val = getNextValue(data.index++);
            }
            bits |= (resb>0 ? 1 : 0) * power;
            power <<= 1;
          }
          dictionary[dictSize++] = f(bits);
          c = dictSize-1;
          enlargeIn--;
          break;
        case 2:
          return result.join('');
      }

      if (enlargeIn == 0) {
        enlargeIn = Math.pow(2, numBits);
        numBits++;
      }

      if (dictionary[c]) {
        entry = dictionary[c];
      } else {
        if (c === dictSize) {
          entry = w + w.charAt(0);
        } else {
          return null;
        }
      }
      result.push(entry);

      // Add w+entry[0] to the dictionary.
      dictionary[dictSize++] = w + entry.charAt(0);
      enlargeIn--;

      w = entry;

      if (enlargeIn == 0) {
        enlargeIn = Math.pow(2, numBits);
        numBits++;
      }

    }
  }
};
  return LZString144;
})();

if (typeof define === 'function' && define.amd) {
  define(function () { return LZString144; });
} else if( typeof module !== 'undefined' && module != null ) {
  module.exports = LZString144
}

//here end LZString code

turbo_launcher.main();
	
})();